package ru.yandex.intranet.imscore.core.services.healthz.impl

import org.springframework.stereotype.Service
import org.springframework.transaction.annotation.Transactional
import ru.yandex.intranet.imscore.core.ports.healthz.HealthzRepository
import ru.yandex.intranet.imscore.core.services.healthz.HealthzService
import ru.yandex.intranet.imscore.metrics.ProbeMetrics

/**
 *  Liveness & Readiness probes service impl
 *
 * @author Mustakayev Marat <mmarat248@yandex-team.ru>
 */
@Service
open class HealthzServiceImpl(
    private val healthzRepository: HealthzRepository,
    private val probeMetrics: ProbeMetrics,
): HealthzService {

    override fun getLiveness(): Boolean {
        probeMetrics.onLivenessProbe()
        return true
    }

    @Transactional(readOnly=true)
    override fun getReadiness(): Boolean {
        var isPostgresError = true
        try {
            healthzRepository.readiness
            isPostgresError = false
        } finally {
            probeMetrics.onReadinessProbe(isPostgresError)
        }
        @Suppress("KotlinConstantConditions")
        return !isPostgresError
    }

}
