package ru.yandex.intranet.imscore.core.services.identity


import ru.yandex.intranet.imscore.core.domain.identity.specification.CreateIdentitySpecification
import ru.yandex.intranet.imscore.core.domain.identity.Identity
import ru.yandex.intranet.imscore.core.domain.identity.specification.UpdateIdentitySpecification
import ru.yandex.intranet.imscore.core.domain.identity.specification.DeleteIdentitySpecification
import ru.yandex.intranet.imscore.core.domain.identity.specification.IdentityListSpecification
import ru.yandex.intranet.imscore.core.domain.identity.specification.IdentitySpecification
import ru.yandex.intranet.imscore.core.domain.identity.specification.MoveIdentitySpecification

/**
 * Identity service
 *
 * @author Mustakayev Marat <mmarat248@yandex-team.ru>
 */
interface IdentityService {

    fun getListBySpec(spec: IdentityListSpecification): List<Identity>

    fun getById(spec: IdentitySpecification): Identity

    fun create(spec: CreateIdentitySpecification): Identity

    fun update(spec: UpdateIdentitySpecification): Identity

    fun delete(spec: DeleteIdentitySpecification)

    fun move(spec: MoveIdentitySpecification)
}
