package ru.yandex.intranet.imscore.core.services.identityGroup

import ru.yandex.intranet.imscore.core.domain.identityRelation.*
import ru.yandex.intranet.imscore.core.domain.identityRelation.specifications.group.AddToGroupSpecification
import ru.yandex.intranet.imscore.core.domain.identityRelation.specifications.group.ExistsInGroupSpecification
import ru.yandex.intranet.imscore.core.domain.identityRelation.specifications.group.ListIdentityGroupsSpecification
import ru.yandex.intranet.imscore.core.domain.identityRelation.specifications.group.RemoveFromGroupSpecification
import ru.yandex.intranet.imscore.core.domain.identityRelation.specifications.group.ReplaceGroupSpecification

/**
 * Identity group service
 *
 * @author Mustakayev Marat <mmarat248@yandex-team.ru>
 */
interface IdentityGroupService {

    fun listIdentityGroups(spec: ListIdentityGroupsSpecification): List<IdentityRelation>

    fun existsInGroup(spec: ExistsInGroupSpecification): Boolean

    fun addToGroup(spec: AddToGroupSpecification)

    fun removeFromGroup(spec: RemoveFromGroupSpecification)

    fun replaceGroup(spec: ReplaceGroupSpecification)
}
