package ru.yandex.intranet.imscore.core.services.identityType.impl

import org.springframework.stereotype.Service
import org.springframework.transaction.annotation.Transactional
import ru.yandex.intranet.imscore.core.domain.identityType.IdentityType
import ru.yandex.intranet.imscore.core.domain.identityType.specifications.IdentityTypeListSpecification
import ru.yandex.intranet.imscore.core.exceptions.identityType.IdentityTypeAlreadyExistsException
import ru.yandex.intranet.imscore.core.ports.IdentityTypeSourceRepository.IdentityTypeSourceRepository
import ru.yandex.intranet.imscore.core.ports.identityType.IdentityTypeRepository
import ru.yandex.intranet.imscore.core.services.identityType.IdentityTypeService

/**
 * IdentityType service implementation
 *
 * @author Mustakayev Marat <mmarat248@yandex-team.ru>
 */
@Service
open class IdentityTypeServiceImpl(
    private val identityTypeRepository: IdentityTypeRepository,
    private val identityTypeSourceRepository: IdentityTypeSourceRepository,
): IdentityTypeService {

    @Transactional(readOnly=true)
    override fun getListBySpec(spec: IdentityTypeListSpecification): List<IdentityType> {
        return identityTypeRepository.getListBySpec(spec)
    }

    @Transactional(readOnly=false)
    override fun create(model: IdentityType): IdentityType {
        val oldIdentityType = identityTypeRepository.findById(model.id!!)

        if (oldIdentityType != null) {
            throw IdentityTypeAlreadyExistsException(model.id)
        }

        val identityTypeSource = identityTypeSourceRepository.getById(model.sourceId!!)
        return identityTypeRepository.save(model, identityTypeSource)
    }

}
