package ru.yandex.intranet.imscore.core.services.identityTypeSource.impl;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import ru.yandex.intranet.imscore.core.domain.IdentityTypeSource.IdentityTypeSource;
import ru.yandex.intranet.imscore.core.domain.IdentityTypeSource.specification.CreateIdentityTypeSourceSpecification;
import ru.yandex.intranet.imscore.core.domain.IdentityTypeSource.specification.UpdateIdentityTypeSourceSpecification;
import ru.yandex.intranet.imscore.core.domain.identityType.IdentityType;
import ru.yandex.intranet.imscore.core.exceptions.StillReferencedException;
import ru.yandex.intranet.imscore.core.exceptions.identityTypeSource.IdentityTypeSourceAlreadyExistsException;
import ru.yandex.intranet.imscore.core.exceptions.identityTypeSource.IdentityTypeSourceNotFoundException;
import ru.yandex.intranet.imscore.core.ports.IdentityTypeSourceRepository.IdentityTypeSourceRepository;
import ru.yandex.intranet.imscore.core.ports.identityType.IdentityTypeRepository;
import ru.yandex.intranet.imscore.core.services.identityTypeSource.IdentityTypeSourceService;

import static org.springframework.util.CollectionUtils.isEmpty;

/**
 * Identity type source service impl.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@Service
public class IdentityTypeSourceServiceImpl implements IdentityTypeSourceService {

    private final IdentityTypeSourceRepository identityTypeSourceRepository;
    private final IdentityTypeRepository identityTypeRepository;

    public IdentityTypeSourceServiceImpl(IdentityTypeSourceRepository identityTypeSourceRepository,
                                         IdentityTypeRepository identityTypeRepository) {
        this.identityTypeSourceRepository = identityTypeSourceRepository;
        this.identityTypeRepository = identityTypeRepository;
    }

    @Override
    @Transactional
    public IdentityTypeSource create(CreateIdentityTypeSourceSpecification spec) {
        IdentityTypeSource oldIdentityTypeSource = identityTypeSourceRepository.findById(spec.getId());

        if (oldIdentityTypeSource != null) {
            throw new IdentityTypeSourceAlreadyExistsException(spec.getId());
        }

        IdentityTypeSource identityTypeSource = new IdentityTypeSource(spec.getId(), spec.getAllowedTvmIds());
        return identityTypeSourceRepository.save(identityTypeSource);
    }

    @Override
    @Transactional
    public IdentityTypeSource update(UpdateIdentityTypeSourceSpecification spec) {
        IdentityTypeSource oldIdentityTypeSource = identityTypeSourceRepository.findById(spec.getId());

        if (oldIdentityTypeSource == null) {
            throw new IdentityTypeSourceNotFoundException(spec.getId());
        }

        IdentityTypeSource identityTypeSource = new IdentityTypeSource(
                spec.getId(),
                spec.getAllowedTvmIds());
        return identityTypeSourceRepository.save(identityTypeSource);
    }

    @Override
    public IdentityTypeSource getById(String id) {
        return identityTypeSourceRepository.getById(id);
    }

    @Override
    @Transactional
    public void delete(String id) {
        List<IdentityType> bySourceId = identityTypeRepository.findBySourceId(id);
        if (!isEmpty(bySourceId)) {
            throw new StillReferencedException(id);
        }

        identityTypeSourceRepository.getById(id);

        identityTypeSourceRepository.deleteById(id);
    }

}
