package ru.yandex.intranet.imscore.infrastructure.configurations.datasources;

import java.util.HashMap;
import java.util.Map;

import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.transaction.support.TransactionSynchronizationManager;


public class ReadWriteRoutingDateSource extends AbstractRoutingDataSource {
    private static final Logger log = LoggerFactory.getLogger(ReadWriteRoutingDateSource.class);

    public ReadWriteRoutingDateSource(DataSource writeDataSource, DataSource readDataSource) {
        Map<Object, Object> dataSourceMap = new HashMap<>();
        dataSourceMap.put("write", writeDataSource);
        dataSourceMap.put("read", readDataSource);

        setTargetDataSources(dataSourceMap);
        setDefaultTargetDataSource(writeDataSource);
    }

    @Override
    protected Object determineCurrentLookupKey() {
        String dataSourceType = TransactionSynchronizationManager.isCurrentTransactionReadOnly() ? "read" : "write";
        log.debug("current dataSourceType: {}", dataSourceType);
        return dataSourceType;
    }
}

