package ru.yandex.intranet.imscore.infrastructure.configurations.datasources;


import org.jetbrains.annotations.NotNull;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class RoutingDataSourceTransactionManager extends JpaTransactionManager {

    @Override
    protected void doBegin(@NotNull Object transaction, TransactionDefinition definition) {
        /*
        Hack: the implementation of the DataSourceTransactionManager receives a connection to the database in doBegin
        and further uses it before the end of the measurement. The readOnly attribute of the transaction is set after
        the connection has been received. This does not allow you to understand at the time the connection is received
        what is the need: for reading or for reading and writing. Here we assume before the connection we set the signs
        of the transaction to read-only.
        */
        boolean readOnly = TransactionSynchronizationManager.isCurrentTransactionReadOnly();
        try {
            TransactionSynchronizationManager.setCurrentTransactionReadOnly(definition.isReadOnly());
            super.doBegin(transaction, definition);
        } finally {
            TransactionSynchronizationManager.setCurrentTransactionReadOnly(readOnly);
        }
    }
}

