package ru.yandex.intranet.imscore.infrastructure.data.converters.identityData

import ru.yandex.intranet.imscore.core.domain.identity.IdentityData
import ru.yandex.intranet.imscore.infrastructure.data.entities.identity.IdentityWithDataEntity
import ru.yandex.intranet.imscore.infrastructure.data.entities.identityData.IdentityDataEntity

/**
 * IdentityData entity converters
 *
 * @author Mustakayev Marat <mmarat248@yandex-team.ru>
 */
class IdentityDataConverters {
    companion object {

        fun toIdentityData (from: IdentityDataEntity): IdentityData {
            return IdentityData(
                from.slug,
                from.name,
                from.lastname,
                from.phone,
                from.email,
                from.additionalData,
            )
        }

        fun toIdentityDataEntity (identity: IdentityWithDataEntity, from: IdentityData): IdentityDataEntity {
            val identityDataEntity = IdentityDataEntity()
            identityDataEntity.id = identity.id
            identityDataEntity.identity = identity
            identityDataEntity.slug = from.slug
            identityDataEntity.name = from.name
            identityDataEntity.lastname = from.lastname
            identityDataEntity.phone = from.phone
            identityDataEntity.email = from.email
            identityDataEntity.additionalData = if (from.additionalData != null ) {
                from.additionalData.toString()
            } else {
                null
            }
            return identityDataEntity
        }

    }
}



