package ru.yandex.intranet.imscore.infrastructure.data.converters.identityRelation

import ru.yandex.intranet.imscore.core.domain.identityRelation.IdentityRelation
import ru.yandex.intranet.imscore.infrastructure.data.entities.identityRelation.IdentityRelationEntity


/**
 * Identity relation entity converters
 *
 * @author Mustakayev Marat <mmarat248@yandex-team.ru>
 */
class IdentityRelationConverters {
    companion object {
        fun toIdentityRelation (from: IdentityRelationEntity): IdentityRelation {
            return IdentityRelation(
                from.identityId,
                from.groupId,
                IdentityRelation.ConnectionType.fromInt(from.connectionType.ordinal),
            )
        }

        fun toIdentityRelationEntity(from: IdentityRelation): IdentityRelationEntity {
            return IdentityRelationEntity(
                from.identityId,
                from.groupId,
                IdentityRelationEntity.ConnectionType.fromInt(from.connectionType.value),
            )
        }

        fun toIdentityRelationList(from: List<IdentityRelationEntity>): List<IdentityRelation> {
            return from.map { toIdentityRelation(it) }.toList()
        }
    }
}







