package ru.yandex.intranet.imscore.infrastructure.data.converters.identityType

import org.springframework.data.domain.Page
import ru.yandex.intranet.imscore.core.domain.identityType.IdentityType
import ru.yandex.intranet.imscore.infrastructure.data.entities.identityType.IdentityTypeEntity
import ru.yandex.intranet.imscore.infrastructure.data.entities.identityTypeSource.IdentityTypeSourceEntity

/**
 * IdentityType entity converters
 *
 * @author Mustakayev Marat <mmarat248@yandex-team.ru>
 */
class IdentityTypeConverters {
    companion object {
        fun toIdentityType(from: IdentityTypeEntity): IdentityType {
            return IdentityType(
                from.id,
                from.isGroup,
                from.source!!.id,
            )
        }

        fun toIdentityTypeEntity(
            from: IdentityType,
            identityTypeSourceEntity: IdentityTypeSourceEntity
        ): IdentityTypeEntity {
            return IdentityTypeEntity(from.id, from.isGroup, identityTypeSourceEntity)
        }

        fun toIdentityTypeList(from: Page<IdentityTypeEntity>): List<IdentityType> {
            return from.map { toIdentityType(it) }.toList()
        }
    }
}


