package ru.yandex.intranet.imscore.infrastructure.data.converters.identityTypeSource;

import ru.yandex.intranet.imscore.core.domain.IdentityTypeSource.IdentityTypeSource;
import ru.yandex.intranet.imscore.infrastructure.data.entities.identityTypeSource.IdentityTypeSourceEntity;

/**
 * Identity type source converters.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public final class IdentityTypeSourceConverters {

    private IdentityTypeSourceConverters() {
    }

    public static IdentityTypeSourceEntity toIdentityTypeSourceEntity(IdentityTypeSource identityTypeSource) {
        IdentityTypeSourceEntity identityTypeSourceEntity = new IdentityTypeSourceEntity();

        identityTypeSourceEntity.setId(identityTypeSource.getId());
        identityTypeSourceEntity.setAllowedTvmIds(identityTypeSource.getAllowedTvmIds());

        return identityTypeSourceEntity;
    }

    public static IdentityTypeSource toIdentityTypeSource(IdentityTypeSourceEntity identityTypeSourceEntity) {
        return new IdentityTypeSource(
                identityTypeSourceEntity.getId(),
                identityTypeSourceEntity.getAllowedTvmIds());
    }

}
