package ru.yandex.intranet.imscore.infrastructure.data.entities

import org.hibernate.annotations.CreationTimestamp
import org.hibernate.annotations.UpdateTimestamp
import java.time.Instant
import javax.persistence.Column
import javax.persistence.MappedSuperclass

/**
 *
 * @author Mustakayev Marat <mmarat248@yandex-team.ru>
 */
@MappedSuperclass
abstract class AuditableEntity<T> : BaseEntity<T>() {
    @field:CreationTimestamp
    @field:Column(name = "created_at", updatable = false, nullable = false)
    open var createdAt: Instant? = null

    @field:UpdateTimestamp
    @field:Column(name = "modified_at", nullable = false)
    open var modifiedAt: Instant? = null
}

