package ru.yandex.intranet.imscore.infrastructure.data.entities

import org.hibernate.annotations.GenericGenerator
import org.springframework.data.util.ProxyUtils
import javax.persistence.*


/**
 * Base entity
 *
 * @author Mustakayev Marat <mmarat248@yandex-team.ru>
 */
@MappedSuperclass
abstract class BaseEntity<T> {
    @Id
    @GeneratedValue(generator = "UUID")
    @GenericGenerator(
        name = "UUID",
        strategy = "org.hibernate.id.UUIDGenerator",
    )
    @Column(name = "id", insertable = true, updatable = false, nullable = false)
    open var id: T? = null

    override fun equals(other: Any?): Boolean {
        other ?: return false
        if (this === other) return true
        if (javaClass != ProxyUtils.getUserClass(other)) return false
        other as BaseEntity<*>
        return this.id != null && this.id == other.id
    }

    override fun hashCode(): Int {
        return id.hashCode()
    }

    override fun toString(): String {
        return "${this.javaClass.simpleName}(id=$id)"
    }
}
