package ru.yandex.intranet.imscore.infrastructure.data.entities.identity

import org.hibernate.annotations.Fetch
import org.hibernate.annotations.FetchMode
import ru.yandex.intranet.imscore.infrastructure.data.entities.AuditableEntity
import ru.yandex.intranet.imscore.infrastructure.data.entities.identityType.IdentityTypeEntity
import java.util.UUID
import javax.persistence.Column
import javax.persistence.FetchType
import javax.persistence.JoinColumn
import javax.persistence.MappedSuperclass
import javax.persistence.OneToOne

@MappedSuperclass
abstract class IdentityBaseEntity: AuditableEntity<UUID>() {

    @Column(name = "parent_id", nullable = true)
    open var parentId: UUID? = null

    @Column(name = "external_id", nullable = true)
    open var externalId: String? = null

    @OneToOne(optional = false, fetch = FetchType.EAGER, cascade = [])
    @JoinColumn(name = "type_id", referencedColumnName = "id", insertable = true, updatable = true)
    @Fetch(value = FetchMode.SELECT)
    open var type: IdentityTypeEntity = IdentityTypeEntity()

}
