package ru.yandex.intranet.imscore.infrastructure.data.entities.identity.projection;

import java.time.Instant;
import java.util.Objects;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;

import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

import ru.yandex.intranet.imscore.infrastructure.data.entities.identityType.IdentityTypeEntity;


/**
 * Identity with data flat projection
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@SuppressWarnings("unused")
@Entity
public class IdentityWithDataFlatProjection {
    @Id
    @Column(name = "id")
    private String id;
    @Column(name = "parent_id")
    private String  parentId;
    @Column(name = "external_id")
    private String  externalId;
    @Column(name = "created_at")
    private Instant createdAt;
    @Column(name = "modified_at")
    private Instant modifiedAt;
    @OneToOne(optional = false, fetch = FetchType.EAGER)
    @JoinColumn(name = "type_id", referencedColumnName = "id")
    @Fetch(value = FetchMode.SELECT)
    private IdentityTypeEntity type;
    @Column(name = "identity_id")
    private String  identityId;
    @Column(name = "slug")
    private String slug;
    @Column(name = "name")
    private String name;
    @Column(name = "lastname")
    private String lastname;
    @Column(name = "phone")
    private String phone;
    @Column(name = "email")
    private String email;
    @Column(name = "additional_data")
    private String additionalData;

    public IdentityWithDataFlatProjection() {
    }

    public String getId() {
        return id;
    }

    public String getParentId() {
        return parentId;
    }

    public String getExternalId() {
        return externalId;
    }

    public Instant getCreatedAt() {
        return createdAt;
    }

    public Instant getModifiedAt() {
        return modifiedAt;
    }

    public IdentityTypeEntity getType() {
        return type;
    }

    public String getIdentityId() {
        return identityId;
    }

    public String getSlug() {
        return slug;
    }

    public String getName() {
        return name;
    }

    public String getLastname() {
        return lastname;
    }

    public String getPhone() {
        return phone;
    }

    public String getEmail() {
        return email;
    }

    public String getAdditionalData() {
        return additionalData;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    public void setModifiedAt(Instant modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public void setType(IdentityTypeEntity type) {
        this.type = type;
    }

    public void setIdentityId(String identityId) {
        this.identityId = identityId;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setAdditionalData(String additionalData) {
        this.additionalData = additionalData;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdentityWithDataFlatProjection that)) {
            return false;
        }
        return Objects.equals(id, that.id) && Objects.equals(parentId, that.parentId) && Objects.equals(externalId,
                that.externalId) && Objects.equals(createdAt, that.createdAt) && Objects.equals(modifiedAt,
                that.modifiedAt) && Objects.equals(type, that.type) && Objects.equals(identityId, that.identityId)
                && Objects.equals(slug, that.slug) && Objects.equals(name, that.name)
                && Objects.equals(lastname, that.lastname) && Objects.equals(phone, that.phone)
                && Objects.equals(email, that.email)
                && Objects.equals(additionalData, that.additionalData);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, parentId, externalId, createdAt, modifiedAt, type, identityId, slug, name, lastname,
                phone, email, additionalData);
    }

    @Override
    public String toString() {
        return "IdentityProjection{" +
                "id='" + id + '\'' +
                ", parentId='" + parentId + '\'' +
                ", externalId='" + externalId + '\'' +
                ", createdAt=" + createdAt +
                ", modifiedAt=" + modifiedAt +
                ", type=" + type +
                ", identityId='" + identityId + '\'' +
                ", slug='" + slug + '\'' +
                ", name='" + name + '\'' +
                ", lastname='" + lastname + '\'' +
                ", phone='" + phone + '\'' +
                ", email='" + email + '\'' +
                ", additional_data='" + additionalData + '\'' +
                '}';
    }
}
