package ru.yandex.intranet.imscore.infrastructure.data.entities.identityData

import com.vladmihalcea.hibernate.type.json.JsonBinaryType
import org.hibernate.annotations.Fetch
import org.hibernate.annotations.FetchMode
import org.hibernate.annotations.GenericGenerator
import org.hibernate.annotations.Parameter
import org.hibernate.annotations.Type
import org.hibernate.annotations.TypeDef
import ru.yandex.intranet.imscore.infrastructure.data.entities.identity.IdentityWithDataEntity
import java.util.UUID
import javax.persistence.Column
import javax.persistence.Entity
import javax.persistence.GeneratedValue
import javax.persistence.Id
import javax.persistence.OneToOne
import javax.persistence.PrimaryKeyJoinColumn
import javax.persistence.Table

/**
 * IdentityData entity
 *
 * @author Mustakayev Marat <mmarat248@yandex-team.ru>
 */
@Entity
@TypeDef(name = "jsonb", typeClass = JsonBinaryType::class)
@Table(name = "identity_data")
open class IdentityDataEntity {

    @Id
    @GeneratedValue(generator = "gen")
    @Column(name = "id", unique = true, insertable = true, updatable = false, nullable = false)
    @GenericGenerator(name="gen", strategy="foreign", parameters= [ Parameter(name="property", value="identity") ] )
    open var id: UUID? = null

    @OneToOne
    @PrimaryKeyJoinColumn
    @Fetch(value = FetchMode.JOIN)
    open var identity: IdentityWithDataEntity = IdentityWithDataEntity()

    @Column(name = "slug", nullable = true)
    open var slug: String? = null

    @Column(name = "name", nullable = true)
    open var name: String? = null

    @Column(name = "lastname", nullable = true)
    open var lastname: String? = null

    @Column(name = "phone", nullable = true)
    open var phone: String? = null

    @Column(name = "email", nullable = true)
    open var email: String? = null

    @Type(type = "jsonb")
    @Column(name = "additional_data", nullable = true)
    open var additionalData: String? = null

}

