package ru.yandex.intranet.imscore.infrastructure.data.entities.identityRelation

import org.hibernate.annotations.Type
import org.springframework.data.domain.Persistable
import ru.yandex.intranet.imscore.infrastructure.data.entities.common.EnumTypePostgres
import java.io.Serializable
import java.util.*
import javax.persistence.*


/**
 * Identity relation entity
 *
 * @author Mustakayev Marat <mmarat248@yandex-team.ru>
 */
@Embeddable
data class IdentityRelationEntityId (
    val identityId : UUID = UUID.randomUUID(),
    val groupId: UUID = UUID.randomUUID(),
) : Serializable

@Entity
@Table(name = "identity_relation")
@IdClass(IdentityRelationEntityId::class)
@org.hibernate.annotations.TypeDef(name = "enum_type", typeClass = EnumTypePostgres::class)
open class IdentityRelationEntity (
    @Id
    @Column(name = "identity_id", nullable = false)
    open val identityId: UUID = UUID.randomUUID(),

    @Id
    @Column(name = "group_id", nullable = false)
    open val groupId: UUID = UUID.randomUUID(),

    @Column(name = "connection_type", nullable = false)
    @Enumerated(EnumType.STRING)
    @Type(type = "enum_type")
    open val connectionType: ConnectionType = ConnectionType.OWNERSHIP,
): Persistable<IdentityRelationEntityId> {

    @Transient
    private var isNew = true

    enum class ConnectionType {
        UNDEFINED, OWNERSHIP, MEMBERSHIP;
        companion object {
            fun fromInt(value: Int) = ConnectionType.values().first { it.ordinal == value }
        }
    }

    override fun getId(): IdentityRelationEntityId? {
        return IdentityRelationEntityId(identityId, groupId)
    }

    @PostPersist
    @PostLoad
    open fun markNotNew() {
        isNew = false
    }

    override fun isNew(): Boolean {
        return isNew
    }

}
