package ru.yandex.intranet.imscore.infrastructure.data.entities.identityType

import org.hibernate.annotations.CacheConcurrencyStrategy
import org.springframework.data.util.ProxyUtils
import ru.yandex.intranet.imscore.infrastructure.data.entities.identityTypeSource.IdentityTypeSourceEntity
import javax.persistence.*
import javax.persistence.Entity
import javax.persistence.Table

/**
 * IdentityType entity
 *
 * @author Mustakayev Marat <mmarat248@yandex-team.ru>
 */
@Entity
@Table(name = "identity_type")
@Cacheable
@org.hibernate.annotations.Cache(usage = CacheConcurrencyStrategy.READ_ONLY)
open class IdentityTypeEntity(

    @Id
    @Column(name = "id", insertable = true, updatable = false, nullable = false)
    open var id: String? = null,

    @Column(name = "is_group", nullable = false)
    open val isGroup: Boolean = false,

    @ManyToOne
    @JoinColumn(name = "source_id", nullable = false)
    open val source: IdentityTypeSourceEntity? = null

) {
    override fun equals(other: Any?): Boolean {
        other ?: return false
        if (this === other) return true
        if (javaClass != ProxyUtils.getUserClass(other)) return false
        other as IdentityTypeEntity
        return this.id != null && this.id == other.id
    }

    override fun hashCode(): Int {
        return id.hashCode()
    }

    override fun toString(): String {
        return "${this.javaClass.simpleName}(id=$id)"
    }
}

