package ru.yandex.intranet.imscore.infrastructure.data.entities.identityTypeSource;

import java.util.Objects;
import java.util.Set;

import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import com.vladmihalcea.hibernate.type.json.JsonBinaryType;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;

/**
 * Identity type source entity
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@Entity
@TypeDef(name = "jsonb", typeClass = JsonBinaryType.class)
@Table(name = "identity_type_source")
@Cacheable
@org.hibernate.annotations.Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public class IdentityTypeSourceEntity {

    @Id
    @Column(name = "id", updatable = false, nullable = false)
    private String id;

    @Type(type = "jsonb")
    @Column(name = "allowed_tvm_ids", nullable = false)
    private Set<Integer> allowedTvmIds;

    public IdentityTypeSourceEntity() {
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Set<Integer> getAllowedTvmIds() {
        return allowedTvmIds;
    }

    public void setAllowedTvmIds(Set<Integer> allowedTvmIds) {
        this.allowedTvmIds = allowedTvmIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdentityTypeSourceEntity that)) {
            return false;
        }
        return Objects.equals(id, that.id) && Objects.equals(allowedTvmIds, that.allowedTvmIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, allowedTvmIds);
    }
}
