package ru.yandex.intranet.imscore.infrastructure.data.repositories.IdentityTypeSourceRepository;

import java.util.Optional;

import org.springframework.stereotype.Repository;

import ru.yandex.intranet.imscore.core.domain.IdentityTypeSource.IdentityTypeSource;
import ru.yandex.intranet.imscore.core.exceptions.identityTypeSource.IdentityTypeSourceNotFoundException;
import ru.yandex.intranet.imscore.core.ports.IdentityTypeSourceRepository.IdentityTypeSourceRepository;
import ru.yandex.intranet.imscore.infrastructure.data.converters.identityTypeSource.IdentityTypeSourceConverters;
import ru.yandex.intranet.imscore.infrastructure.data.entities.identityTypeSource.IdentityTypeSourceEntity;
import ru.yandex.intranet.imscore.infrastructure.data.repositories.IdentityTypeSourceRepository.jpa.JpaIdentityTypeSourceRepository;

/**
 * Identity type source repository impl.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@Repository
public class IdentityTypeSourceRepositoryImpl implements IdentityTypeSourceRepository {

    private final JpaIdentityTypeSourceRepository jpaIdentityTypeSourceRepository;

    public IdentityTypeSourceRepositoryImpl(JpaIdentityTypeSourceRepository jpaIdentityTypeSourceRepository) {
        this.jpaIdentityTypeSourceRepository = jpaIdentityTypeSourceRepository;
    }

    @Override
    public IdentityTypeSource save(IdentityTypeSource identityTypeSource) {
        IdentityTypeSourceEntity identityTypeSourceEntity =
                IdentityTypeSourceConverters.toIdentityTypeSourceEntity(identityTypeSource);
        return IdentityTypeSourceConverters.toIdentityTypeSource(
                jpaIdentityTypeSourceRepository.saveAndFlush(identityTypeSourceEntity)
        );
    }

    @Override
    public IdentityTypeSource getById(String id) {
        Optional<IdentityTypeSourceEntity> identityTypeSourceO = jpaIdentityTypeSourceRepository.findById(id);
        IdentityTypeSourceEntity identityTypeSource =
                identityTypeSourceO.orElseThrow(() -> new IdentityTypeSourceNotFoundException(id));

        return IdentityTypeSourceConverters.toIdentityTypeSource(identityTypeSource);
    }

    @Override
    public IdentityTypeSource findById(String id) {
        Optional<IdentityTypeSourceEntity> identityTypeSourceO = jpaIdentityTypeSourceRepository.findById(id);

        return identityTypeSourceO
                .map(IdentityTypeSourceConverters::toIdentityTypeSource)
                .orElse(null);
    }

    @Override
    public void deleteById(String id) {
        jpaIdentityTypeSourceRepository.deleteById(id);
    }
}
