package ru.yandex.intranet.imscore.infrastructure.data.repositories.baseRepository.jpa;

import java.io.Serializable;
import java.util.List;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.repository.NoRepositoryBean;

/**
 * Custom {@link org.springframework.data.repository.CrudRepository} interface with
 * {@link #findAll(Specification, long, int)} and {@link #findAll(Specification, long, int, Sort)}
 * without count request.
 *
 * @param <T> the type of the entity to handle
 * @param <ID> the type of the entity's identifier
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@NoRepositoryBean
public interface BaseRepository<T, ID extends Serializable> extends JpaRepository<T, ID> {

    List<T> findAll(Specification<T> spec, long offset, int maxResults, Sort sort);
    List<T> findAll(Specification<T> spec, long offset, int maxResults);
    Page<T> findAll(Specification<T> spec, Pageable pageable);

}
