package ru.yandex.intranet.imscore.infrastructure.data.repositories.healthz.jpa;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import ru.yandex.intranet.imscore.core.ports.healthz.HealthzRepository;
import ru.yandex.intranet.imscore.infrastructure.data.entities.BaseEntity;

/**
 * Jpa healthz repository;
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@Repository
public interface JpaHealthzRepository extends JpaRepository<BaseEntity<Boolean>, Void>, HealthzRepository {
    @Override
    @Query(value = "SELECT true;", nativeQuery = true)
    boolean getReadiness();
}
