package ru.yandex.intranet.imscore.infrastructure.data.repositories.identity.jpa;

import java.util.List;
import java.util.UUID;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import ru.yandex.intranet.imscore.infrastructure.data.entities.identity.projection.IdentityWithDataFlatProjection;

/**
 * Identity with data flat projection jpa repository interface
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@Repository
public interface JpaIdentityWithDataFlatProjectionRepository extends
        JpaRepository<IdentityWithDataFlatProjection, UUID>, JpaSpecificationExecutor<IdentityWithDataFlatProjection> {
    @Query(value = """
        WITH RECURSIVE
            r AS (SELECT i.identity_id, i.group_id, i.connection_type
                  FROM identity_relation i
                  WHERE i.group_id = :groupId
                  UNION
                  SELECT ir.identity_id, ir.group_id, ir.connection_type
                  FROM identity_relation ir
                           JOIN r ON ir.group_id = r.identity_id
                      AND (:onlyDirectly IS false)),
            identitys AS (SELECT DISTINCT r.identity_id
                          FROM r
                          WHERE (:cursor IS NULL
                              OR
                                 (r.identity_id > cast(cast(:cursor AS text) AS uuid))
                                    )
                          ORDER BY identity_id
                          LIMIT :limit)
        SELECT cast(identity.id AS varchar) AS id,
               cast(parent_id AS varchar),
               external_id,
               cast(type_id AS varchar),
               created_at,
               modified_at,
               cast(d.id AS varchar) AS identity_id,
               slug,
               name,
               lastname,
               phone,
               email,
               additional_data
        FROM identity
                 LEFT JOIN identity_data d ON identity.id = d.id AND :loadData
        WHERE identity.id in (SELECT identity_id as id FROM identitys)
        ORDER BY identity.id
    """, nativeQuery = true)
    List<IdentityWithDataFlatProjection> findAllIdentitiesByGroupId(
            UUID groupId,
            boolean onlyDirectly,
            boolean loadData,
            UUID cursor,
            int limit
    );
}
