package ru.yandex.intranet.imscore.infrastructure.data.repositories.identity.jpa;

import java.util.Optional;
import java.util.UUID;

import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import ru.yandex.intranet.imscore.infrastructure.data.entities.identity.IdentityWithDataEntity;
import ru.yandex.intranet.imscore.infrastructure.data.repositories.baseRepository.jpa.BaseRepository;

/**
 * Identity with data jpa repository interface
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@Repository
public interface JpaIdentityWithDataRepository extends
        BaseRepository<IdentityWithDataEntity, UUID>, JpaSpecificationExecutor<IdentityWithDataEntity> {

    @NotNull
    @Override
    Page<IdentityWithDataEntity> findAll(Specification<IdentityWithDataEntity> spec, @NotNull Pageable pageable);

    @NotNull
    @Query("SELECT i FROM IdentityWithDataEntity i LEFT JOIN FETCH i.data WHERE i.id = :id")
    Optional<IdentityWithDataEntity> findByIdWithData(UUID id);

    @NotNull
    @Query("""
            SELECT i FROM IdentityWithDataEntity i LEFT JOIN FETCH i.data WHERE i.externalId = :externalId
            AND i.type.id = :typeId""")
    Optional<IdentityWithDataEntity> findByExternalIdAndTypeIdWithData(String externalId, String typeId);

}
