package ru.yandex.intranet.imscore.infrastructure.data.repositories.identity.specifications;

import java.util.List;
import java.util.UUID;

import javax.persistence.Entity;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.JoinType;

import org.springframework.data.jpa.domain.Specification;

import ru.yandex.intranet.imscore.infrastructure.data.entities.identity.IdentityBaseEntity;
import ru.yandex.intranet.imscore.infrastructure.data.entities.identity.IdentityWithDataEntity;

import static liquibase.util.StringUtil.isEmpty;

public final class IdentitySpecifications {

    private IdentitySpecifications() {
    }

    public static <T extends IdentityBaseEntity> Specification<T> byIds(List<UUID> ids) {
        return (root, query, criteriaBuilder) -> {
            if (ids != null && !ids.isEmpty()) {
                return root.get("id").in(ids);
            } else {
                return criteriaBuilder.and();
            }
        };
    }

    public static <T extends IdentityBaseEntity> Specification<T> greaterId(UUID id) {
        return (root, query, criteriaBuilder) -> {
            if (id != null) {
                return  criteriaBuilder.greaterThan(root.get("id"), id);
            } else {
                return null;
            }
        };
    }

    public static <T extends IdentityBaseEntity> Specification<T> byTypeId(String typeId) {
        return (root, query, criteriaBuilder) -> {
            if (!isEmpty(typeId)) {
                return  criteriaBuilder.equal(root.get("typeId"), typeId);
            } else {
                return null;
            }
        };
    }

    public static <T extends IdentityWithDataEntity> Specification<T> fetchData() {
        return (root, query, criteriaBuilder) -> {
            if (isCountQuery(query)) {
                root.join("data", JoinType.LEFT);
            } else {
                root.fetch("data", JoinType.LEFT);
            }
            return null;
        };
    }

    private static boolean isCountQuery(CriteriaQuery<?> query) {
        return query.getResultType().getAnnotation(Entity.class) == null;
    }


}
