package ru.yandex.intranet.imscore.infrastructure.data.repositories.identityRelation.specifications;

import java.util.UUID;

import org.springframework.data.jpa.domain.Specification;

import ru.yandex.intranet.imscore.infrastructure.data.entities.identityRelation.IdentityRelationEntity;

/**
 * Identity relation specifications
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public final class IdentityRelationSpecifications {
    private IdentityRelationSpecifications() {
    }

    public static Specification<IdentityRelationEntity> greaterIdentityId(UUID identityId) {
        return (root, ignored, cb) -> identityId != null ? cb.greaterThan(root.get("identity_id"), identityId)
                : cb.conjunction();
    }

    public static Specification<IdentityRelationEntity> greaterGroupId(UUID groupId) {
        return (root, ignored, cb) -> groupId != null ? cb.greaterThan(root.get("group_id"), groupId)
                : cb.conjunction();
    }
}
