package ru.yandex.intranet.imscore.infrastructure.data.repositories.identityType.jpa


import org.springframework.data.jpa.repository.JpaRepository
import org.springframework.data.jpa.repository.JpaSpecificationExecutor
import org.springframework.data.jpa.repository.Query
import org.springframework.stereotype.Repository
import ru.yandex.intranet.imscore.infrastructure.data.entities.identityType.IdentityTypeEntity

/**
 * Identity Type jpa repository interface
 *
 * @author Mustakayev Marat <mmarat248@yandex-team.ru>
 */
@Repository
interface JpaIdentityTypeRepository:
    JpaRepository<IdentityTypeEntity, String>, JpaSpecificationExecutor<IdentityTypeEntity> {

    @Query("""
        SELECT i
        FROM IdentityTypeEntity i
        WHERE i.source.id = :sourceId""")
    fun findBySourceId(sourceId: String): List<IdentityTypeEntity>

}
