package ru.yandex.intranet.imscore.infrastructure.presentation.grpc;

import java.util.function.Consumer;

import io.grpc.Context;
import io.grpc.stub.StreamObserver;

import ru.yandex.intranet.imscore.infrastructure.presentation.grpc.interceptors.AccessLogInterceptor;
import ru.yandex.intranet.imscore.infrastructure.presentation.grpc.interceptors.ExceptionLoggingResponseObserver;

/**
 * GRPC helpers.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public final class Grpc {

    private Grpc() {
    }

    public static <TResponse> void toExceptionStreamObserver(
            StreamObserver<TResponse> responseObserver,
            Consumer<StreamObserver<TResponse>> streamObserverConsumer) {
        Context context = Context.current();
        ExceptionLoggingResponseObserver<TResponse> t = exceptionLoggingObserver(responseObserver, context);
        try {
            streamObserverConsumer.accept(t);
        } catch (Exception e) {
            t.onError(e);
        }
    }

    private static <TResponse> ExceptionLoggingResponseObserver<TResponse> exceptionLoggingObserver(
            StreamObserver<TResponse> responseObserver, Context context) {
        return new ExceptionLoggingResponseObserver<>(responseObserver, AccessLogInterceptor.LOG_ID_KEY.get(context));
    }

}
