package ru.yandex.intranet.imscore.infrastructure.presentation.grpc.config;

import io.grpc.protobuf.services.HealthStatusManager;
import net.devh.boot.grpc.server.interceptor.GlobalServerInterceptorRegistry;
import net.devh.boot.grpc.server.serverfactory.GrpcServerConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * GRPC configuration.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@Configuration
public class GrpcConfiguration {

    @Bean
    public HealthStatusManager healthStatusManager() {
        return new HealthStatusManager();
    }

    @Bean
    public GrpcServerConfigurer grpcReflectionConfigurer(
            GlobalServerInterceptorRegistry globalServerInterceptorRegistry) {
        return new GrpcReflectionConfigurer(globalServerInterceptorRegistry);
    }

    @Bean
    public GrpcServerConfigurer grpcHealthCheckConfigurer(
            GlobalServerInterceptorRegistry globalServerInterceptorRegistry,
            HealthStatusManager healthStatusManager) {
        return new GrpcHealthCheckConfigurer(globalServerInterceptorRegistry, healthStatusManager);
    }

}
