package ru.yandex.intranet.imscore.infrastructure.presentation.grpc.converters.identityType

import ru.yandex.intranet.imscore.core.domain.identityType.specifications.IdentityTypeListSpecification
import ru.yandex.intranet.imscore.core.domain.identityType.IdentityType
import ru.yandex.intranet.imscore.infrastructure.presentation.grpc.validators.PageTokenUtils
import ru.yandex.intranet.imscore.infrastructure.shared.Constants.Companion.DEFAULT_PAGE_SIZE
import ru.yandex.intranet.imscore.proto.identityType.*

/**
 * IdentityType proto converters
 *
 * @author Mustakayev Marat <mmarat248@yandex-team.ru>
 */
class IdentityTypeProtoConverters {

    companion object {

        fun toListIdentityTypesResponse(from: List<IdentityType>, pageSize: Int): ListIdentityTypesResponse {
            val identityTypes = from.stream().map {
                toIdentityTypeProto(it)
            }.toList()
            val list = ListIdentityTypesResponse.newBuilder().addAllIdentityTypes(identityTypes)
            if (from.isNotEmpty() && from.size == pageSize) {
                list.nextPageToken = PageTokenUtils.encode(listOf(from.last().id.toString()))
            }
            return list.build()
        }

        fun toIdentityTypeListSpecification(from: ListIdentityTypesRequest,
            cursor: String?): IdentityTypeListSpecification {
            return IdentityTypeListSpecification(
                cursor = cursor,
                size = if(from.pageSize > 0) from.pageSize else DEFAULT_PAGE_SIZE,
            )
        }

        fun toIdentityType(from: CreateIdentityTypeRequest): IdentityType {
            return IdentityType(
                from.id,
                from.isGroup,
                from.sourceId,
            )
        }

        fun toCreateIdentityTypeResponse(from: IdentityType): CreateIdentityTypeResponse {
            return CreateIdentityTypeResponse.newBuilder()
                .setIdentityType(
                    toIdentityTypeProto(from)
                )
                .build()
        }

        private fun toIdentityTypeProto(from: IdentityType): ru.yandex.intranet.imscore.proto.identityType.IdentityType {
            return ru.yandex.intranet.imscore.proto.identityType.IdentityType.newBuilder()
                .setId(from.id)
                .setIsGroup(from.isGroup)
                .setSourceId(from.sourceId)
                .build()
        }

    }
}
