package ru.yandex.intranet.imscore.infrastructure.presentation.grpc.converters.identityTypeSourceProtoConverters;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import ru.yandex.intranet.imscore.core.domain.IdentityTypeSource.IdentityTypeSource;
import ru.yandex.intranet.imscore.core.domain.IdentityTypeSource.specification.CreateIdentityTypeSourceSpecification;
import ru.yandex.intranet.imscore.core.domain.IdentityTypeSource.specification.UpdateIdentityTypeSourceSpecification;
import ru.yandex.intranet.imscore.proto.identityTypeSource.CreateIdentityTypeSourceRequest;
import ru.yandex.intranet.imscore.proto.identityTypeSource.CreateIdentityTypeSourceResponse;
import ru.yandex.intranet.imscore.proto.identityTypeSource.GetIdentityTypeSourceResponse;
import ru.yandex.intranet.imscore.proto.identityTypeSource.UpdateIdentityTypeSourceRequest;
import ru.yandex.intranet.imscore.proto.identityTypeSource.UpdateIdentityTypeSourceResponse;

import static org.springframework.util.CollectionUtils.isEmpty;

/**
 * Identity type source proto converters.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public final class IdentityTypeSourceProtoConverters {

    private IdentityTypeSourceProtoConverters() {
    }


    public static GetIdentityTypeSourceResponse toGetIdentityTypeSourceResponse(IdentityTypeSource identityTypeSource) {
        return GetIdentityTypeSourceResponse.newBuilder()
                .setIdentityTypeSource(toIdentityTypeSource(identityTypeSource))
                .build();
    }

    public static CreateIdentityTypeSourceSpecification toCreateIdentityTypeSourceSpecification(
            CreateIdentityTypeSourceRequest createIdentityTypeSourceRequest) {
        Set<Integer> allowedTvmIds = new HashSet<>();

        List<Integer> allowedTvmIdsList = createIdentityTypeSourceRequest.getAllowedTvmIdsList();
        if (!isEmpty(allowedTvmIdsList)) {
            allowedTvmIds.addAll(allowedTvmIdsList);
        }

        return new CreateIdentityTypeSourceSpecification(createIdentityTypeSourceRequest.getId(), allowedTvmIds);
    }

    public static CreateIdentityTypeSourceResponse toCreateIdentityTypeSourceResponse(
            IdentityTypeSource identityTypeSource) {
        return CreateIdentityTypeSourceResponse.newBuilder()
                .setIdentityTypeSource(toIdentityTypeSource(identityTypeSource))
                .build();
    }

    public static UpdateIdentityTypeSourceSpecification toUpdateIdentityTypeSourceSpecification(
            UpdateIdentityTypeSourceRequest request) {
        Set<Integer> allowedTvmIds = new HashSet<>();

        List<Integer> allowedTvmIdsList = request.getAllowedTvmIdsList();
        if (!isEmpty(allowedTvmIdsList)) {
            allowedTvmIds.addAll(allowedTvmIdsList);
        }

        return new UpdateIdentityTypeSourceSpecification(request.getId(),
                allowedTvmIds);
    }

    public static UpdateIdentityTypeSourceResponse toUpdateIdentityTypeSourceResponse(
            IdentityTypeSource identityTypeSource) {
        return UpdateIdentityTypeSourceResponse.newBuilder()
                .setIdentityTypeSource(toIdentityTypeSource(identityTypeSource))
                .build();
    }

    public static ru.yandex.intranet.imscore.proto.identityTypeSource.IdentityTypeSource toIdentityTypeSource(
            IdentityTypeSource identityTypeSource) {
        return ru.yandex.intranet.imscore.proto.identityTypeSource.IdentityTypeSource.newBuilder()
                .setId(identityTypeSource.getId())
                .addAllAllowedTvmIds(identityTypeSource.getAllowedTvmIds())
                .build();
    }
}
