package ru.yandex.intranet.imscore.infrastructure.presentation.grpc.services.healthz

import com.google.protobuf.Empty
import io.grpc.stub.StreamObserver
import net.devh.boot.grpc.server.service.GrpcService
import ru.yandex.intranet.imscore.core.services.healthz.HealthzService
import ru.yandex.intranet.imscore.infrastructure.presentation.grpc.Grpc
import ru.yandex.intranet.imscore.proto.healthz.HealthzCheckResponse
import ru.yandex.intranet.imscore.proto.healthz.HealthzGrpc
import java.util.concurrent.atomic.AtomicBoolean

/**
 * Healthz grpc service implementation
 *
 * @author Mustakayev Marat <mmarat248@yandex-team.ru>
 */
@GrpcService
class GrpcHealthzServiceImpl(
    private val healthzService: HealthzService
): HealthzGrpc.HealthzImplBase() {
    companion object {
        val READNESS_STATUS = AtomicBoolean()
    }

    override fun liveness(request: Empty, responseObserver: StreamObserver<HealthzCheckResponse>) {
        Grpc.toExceptionStreamObserver(responseObserver) { streamResponseObserver ->
            val status = healthzService.getLiveness()

            val responseBuilder = HealthzCheckResponse.newBuilder()
            responseBuilder.status = if (status) HealthzCheckResponse.Status.OK else HealthzCheckResponse.Status.FAIL
            streamResponseObserver.onNext(responseBuilder.build())
            streamResponseObserver.onCompleted()
        }
    }

    override fun readness(request: Empty, responseObserver: StreamObserver<HealthzCheckResponse>) {
        Grpc.toExceptionStreamObserver(responseObserver) { streamResponseObserver ->
            var currentStatus = READNESS_STATUS.get()

            if (!currentStatus) {
                currentStatus = healthzService.getReadiness()
                READNESS_STATUS.compareAndExchange(false, currentStatus)
            }

            val responseBuilder = HealthzCheckResponse.newBuilder()
            responseBuilder.status =
                if (currentStatus) HealthzCheckResponse.Status.OK else HealthzCheckResponse.Status.FAIL
            streamResponseObserver.onNext(responseBuilder.build())
            streamResponseObserver.onCompleted()
        }
    }

}
