package ru.yandex.intranet.imscore.infrastructure.presentation.grpc.services.identityType

import io.grpc.stub.StreamObserver
import net.devh.boot.grpc.server.service.GrpcService
import ru.yandex.intranet.imscore.core.services.identityType.IdentityTypeService
import ru.yandex.intranet.imscore.infrastructure.presentation.grpc.Grpc.toExceptionStreamObserver
import ru.yandex.intranet.imscore.infrastructure.presentation.grpc.converters.identityType.*
import ru.yandex.intranet.imscore.infrastructure.presentation.grpc.validators.itentityType.IdentityTypeProtoValidators
import ru.yandex.intranet.imscore.proto.identityType.*


/**
 * IdentityType grpc service implementation
 *
 * @author Mustakayev Marat <mmarat248@yandex-team.ru>
 */
@Suppress("unused")
@GrpcService
class GrpcIdentityTypeImpl(
    private val identityTypeService: IdentityTypeService
): IdentityTypeServiceGrpc.IdentityTypeServiceImplBase() {
    override fun listIdentityTypes(
        request: ListIdentityTypesRequest,
        responseObserver: StreamObserver<ListIdentityTypesResponse>
    ) {
        toExceptionStreamObserver(responseObserver) { streamResponseObserver ->
            val cursor = IdentityTypeProtoValidators.validateListIdentityTypesRequest(request)

            val spec = IdentityTypeProtoConverters.toIdentityTypeListSpecification(request, cursor)
            val identityTypes = identityTypeService.getListBySpec(spec)
            val response = IdentityTypeProtoConverters.toListIdentityTypesResponse(
                identityTypes, spec.size
            )
            streamResponseObserver.onNext(response)
            streamResponseObserver.onCompleted()
        }
    }

    override fun createIdentityType(
        request: CreateIdentityTypeRequest,
        responseObserver: StreamObserver<CreateIdentityTypeResponse>
    ) {
        toExceptionStreamObserver(responseObserver) { streamResponseObserver ->
            IdentityTypeProtoValidators.validateCreateIdentityTypeRequest(request)

            val identityTypes = identityTypeService.create(IdentityTypeProtoConverters.toIdentityType(request))
            val response = IdentityTypeProtoConverters.toCreateIdentityTypeResponse(identityTypes)
            streamResponseObserver.onNext(response)
            streamResponseObserver.onCompleted()
        }
    }
}
