package ru.yandex.intranet.imscore.infrastructure.presentation.grpc.services.identityTypeSource;

import com.google.protobuf.Empty;
import io.grpc.stub.StreamObserver;
import net.devh.boot.grpc.server.service.GrpcService;

import ru.yandex.intranet.imscore.core.domain.IdentityTypeSource.IdentityTypeSource;
import ru.yandex.intranet.imscore.core.domain.IdentityTypeSource.specification.CreateIdentityTypeSourceSpecification;
import ru.yandex.intranet.imscore.core.domain.IdentityTypeSource.specification.UpdateIdentityTypeSourceSpecification;
import ru.yandex.intranet.imscore.core.services.identityTypeSource.IdentityTypeSourceService;
import ru.yandex.intranet.imscore.infrastructure.presentation.grpc.converters.identityTypeSourceProtoConverters.IdentityTypeSourceProtoConverters;
import ru.yandex.intranet.imscore.infrastructure.presentation.grpc.validators.identityTypeSource.IdentityTypeSourceProtoValidators;
import ru.yandex.intranet.imscore.proto.identityTypeSource.CreateIdentityTypeSourceRequest;
import ru.yandex.intranet.imscore.proto.identityTypeSource.CreateIdentityTypeSourceResponse;
import ru.yandex.intranet.imscore.proto.identityTypeSource.DeleteIdentityTypeSourceRequest;
import ru.yandex.intranet.imscore.proto.identityTypeSource.GetIdentityTypeSourceRequest;
import ru.yandex.intranet.imscore.proto.identityTypeSource.GetIdentityTypeSourceResponse;
import ru.yandex.intranet.imscore.proto.identityTypeSource.IdentityTypeSourceServiceGrpc;
import ru.yandex.intranet.imscore.proto.identityTypeSource.UpdateIdentityTypeSourceRequest;
import ru.yandex.intranet.imscore.proto.identityTypeSource.UpdateIdentityTypeSourceResponse;

import static ru.yandex.intranet.imscore.infrastructure.presentation.grpc.Grpc.toExceptionStreamObserver;

/**
 * Grpc identity type source impl.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@GrpcService
public class GrpcIdentityTypeSourceImpl extends IdentityTypeSourceServiceGrpc.IdentityTypeSourceServiceImplBase {

    private final IdentityTypeSourceService identityTypeSourceService;

    public GrpcIdentityTypeSourceImpl(IdentityTypeSourceService identityTypeSourceService) {
        this.identityTypeSourceService = identityTypeSourceService;
    }

    @Override
    public void getIdentityTypeSource(GetIdentityTypeSourceRequest request,
                                      StreamObserver<GetIdentityTypeSourceResponse> responseObserver) {
        toExceptionStreamObserver(responseObserver, streamResponseObserver -> {
            IdentityTypeSourceProtoValidators.validateGetIdentityTypeSourceRequest(request);

            IdentityTypeSource identityTypeSource = identityTypeSourceService.getById(request.getId());

            GetIdentityTypeSourceResponse response =
                    IdentityTypeSourceProtoConverters.toGetIdentityTypeSourceResponse(identityTypeSource);

            streamResponseObserver.onNext(response);
            streamResponseObserver.onCompleted();
        });
    }

    @Override
    public void createIdentityTypeSource(CreateIdentityTypeSourceRequest request,
                                         StreamObserver<CreateIdentityTypeSourceResponse> responseObserver) {
        toExceptionStreamObserver(responseObserver, streamResponseObserver -> {
            IdentityTypeSourceProtoValidators.validateCreateIdentityTypeSourceRequest(request);

            CreateIdentityTypeSourceSpecification createIdentityTypeSourceSpecification =
                    IdentityTypeSourceProtoConverters.toCreateIdentityTypeSourceSpecification(request);
            IdentityTypeSource identityTypeSource = identityTypeSourceService.create(
                    createIdentityTypeSourceSpecification);

            CreateIdentityTypeSourceResponse response =
                    IdentityTypeSourceProtoConverters.toCreateIdentityTypeSourceResponse(identityTypeSource);

            streamResponseObserver.onNext(response);
            streamResponseObserver.onCompleted();
        });
    }

    @Override
    public void updateIdentityTypeSource(UpdateIdentityTypeSourceRequest request,
                                         StreamObserver<UpdateIdentityTypeSourceResponse> responseObserver) {
        toExceptionStreamObserver(responseObserver, streamResponseObserver -> {
            IdentityTypeSourceProtoValidators.validateUpdateIdentityTypeSourceRequest(request);

            UpdateIdentityTypeSourceSpecification updateIdentityTypeSourceSpecification =
                    IdentityTypeSourceProtoConverters.toUpdateIdentityTypeSourceSpecification(request);
            IdentityTypeSource identityTypeSource = identityTypeSourceService.update(
                    updateIdentityTypeSourceSpecification);

            UpdateIdentityTypeSourceResponse response =
                    IdentityTypeSourceProtoConverters.toUpdateIdentityTypeSourceResponse(identityTypeSource);

            streamResponseObserver.onNext(response);
            streamResponseObserver.onCompleted();
        });
    }

    @Override
    public void deleteIdentityTypeSource(DeleteIdentityTypeSourceRequest request,
                                         StreamObserver<Empty> responseObserver) {
        toExceptionStreamObserver(responseObserver, streamResponseObserver -> {
            IdentityTypeSourceProtoValidators.validateDeleteIdentityTypeSourceRequest(request);

            identityTypeSourceService.delete(request.getId());

            streamResponseObserver.onNext(Empty.newBuilder()
                    .build());
            streamResponseObserver.onCompleted();
        });
    }
}
