package ru.yandex.intranet.imscore.infrastructure.presentation.grpc.validators;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;

import org.jetbrains.annotations.Nullable;

import static org.springframework.util.CollectionUtils.isEmpty;


/**
 * Page token utils
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public final class PageTokenUtils {
    public static final String TOKEN_DELIM = ";";

    private PageTokenUtils() {
    }

    public static @Nullable List<String> decode(@Nullable String pageToken) throws IllegalArgumentException {
        if (pageToken == null || pageToken.equals(GrpcValidatorUtils.Companion.getDefaultValue())) {
            return null;
        }

        byte[] decodeBytes = Base64.getDecoder().decode(pageToken);
        String decodedString = new String(decodeBytes, StandardCharsets.UTF_8);
        return Arrays.asList(decodedString.split(TOKEN_DELIM));
    }

    public static @Nullable String encode(@Nullable List<String> tokens) {
        if (isEmpty(tokens)) {
            return null;
        }

        String joinString = String.join(TOKEN_DELIM, tokens);
        return Base64.getEncoder().encodeToString(joinString.getBytes(StandardCharsets.UTF_8));
    }
}
