package ru.yandex.intranet.imscore.infrastructure.presentation.grpc.validators.identityTypeSource;

import java.util.ArrayList;
import java.util.List;

import com.google.rpc.Code;

import ru.yandex.intranet.imscore.infrastructure.presentation.grpc.exceptions.ValidationException;
import ru.yandex.intranet.imscore.infrastructure.presentation.grpc.validators.GrpcValidatorUtils;
import ru.yandex.intranet.imscore.proto.error.ErrorDetails;
import ru.yandex.intranet.imscore.proto.error.FieldError;
import ru.yandex.intranet.imscore.proto.identityTypeSource.CreateIdentityTypeSourceRequest;
import ru.yandex.intranet.imscore.proto.identityTypeSource.DeleteIdentityTypeSourceRequest;
import ru.yandex.intranet.imscore.proto.identityTypeSource.GetIdentityTypeSourceRequest;
import ru.yandex.intranet.imscore.proto.identityTypeSource.UpdateIdentityTypeSourceRequest;

/**
 * Identity type source proto validators.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public final class IdentityTypeSourceProtoValidators {

    private IdentityTypeSourceProtoValidators() {
    }

    public static void validateGetIdentityTypeSourceRequest(GetIdentityTypeSourceRequest request) {
        List<FieldError> fieldErrors = new ArrayList<>();
        FieldError fieldError = GrpcValidatorUtils.Companion.validateRequired("id", request.getId(), true);

        if (fieldError != null) {
            fieldErrors.add(fieldError);
        }

        if (!fieldErrors.isEmpty()) {
            throw new ValidationException(
                    Code.INVALID_ARGUMENT.name(),
                    ErrorDetails.newBuilder().addAllFieldErrors(fieldErrors).build()
            );
        }
    }

    @SuppressWarnings("unused")
    public static void validateCreateIdentityTypeSourceRequest(CreateIdentityTypeSourceRequest request) {
        List<FieldError> fieldErrors = new ArrayList<>();
        FieldError fieldError = GrpcValidatorUtils.Companion.validateRequired("id", request.getId(), true);

        if (fieldError != null) {
            fieldErrors.add(fieldError);
        }

        if (!fieldErrors.isEmpty()) {
            throw new ValidationException(
                    Code.INVALID_ARGUMENT.name(),
                    ErrorDetails.newBuilder().addAllFieldErrors(fieldErrors).build()
            );
        }
    }

    public static void validateUpdateIdentityTypeSourceRequest(UpdateIdentityTypeSourceRequest request) {
        List<FieldError> fieldErrors = new ArrayList<>();
        FieldError fieldError = GrpcValidatorUtils.Companion.validateRequired("id", request.getId(), true);

        if (fieldError != null) {
            fieldErrors.add(fieldError);
        }

        if (!fieldErrors.isEmpty()) {
            throw new ValidationException(
                    Code.INVALID_ARGUMENT.name(),
                    ErrorDetails.newBuilder().addAllFieldErrors(fieldErrors).build()
            );
        }
    }

    public static void validateDeleteIdentityTypeSourceRequest(DeleteIdentityTypeSourceRequest request) {
        List<FieldError> fieldErrors = new ArrayList<>();
        FieldError fieldError = GrpcValidatorUtils.Companion.validateRequired("id", request.getId(), true);

        if (fieldError != null) {
            fieldErrors.add(fieldError);
        }

        if (!fieldErrors.isEmpty()) {
            throw new ValidationException(
                    Code.INVALID_ARGUMENT.name(),
                    ErrorDetails.newBuilder().addAllFieldErrors(fieldErrors).build()
            );
        }
    }
}
