package ru.yandex.intranet.imscore.infrastructure.presentation.grpc.validators.itentityType

import com.google.rpc.Code
import ru.yandex.intranet.imscore.infrastructure.presentation.grpc.exceptions.ValidationException
import ru.yandex.intranet.imscore.infrastructure.presentation.grpc.validators.GrpcValidatorUtils.Companion.validateB64PageToken
import ru.yandex.intranet.imscore.infrastructure.presentation.grpc.validators.GrpcValidatorUtils.Companion.validateListPageSize
import ru.yandex.intranet.imscore.infrastructure.presentation.grpc.validators.GrpcValidatorUtils.Companion.validateRequired
import ru.yandex.intranet.imscore.proto.error.ErrorDetails
import ru.yandex.intranet.imscore.proto.error.FieldError
import ru.yandex.intranet.imscore.proto.identityType.CreateIdentityTypeRequest
import ru.yandex.intranet.imscore.proto.identityType.ListIdentityTypesRequest

/**
 *  IdentityType grpc validators
 *
 * @author Mustakayev Marat <mmarat248@yandex-team.ru>
 */
class IdentityTypeProtoValidators {
    companion object {
        fun validateCreateIdentityTypeRequest(req: CreateIdentityTypeRequest) {
            val fieldErrors = mutableListOf<FieldError>()

            var fieldError: FieldError? = validateRequired("id", req.id)

            if (fieldError != null) {
                fieldErrors.add(fieldError)
            }

            fieldError = validateRequired("source_id", req.sourceId)

            if (fieldError != null) {
                fieldErrors.add(fieldError)
            }


            if (fieldErrors.isNotEmpty()) {
                throw ValidationException(
                    Code.INVALID_ARGUMENT.name,
                    ErrorDetails.newBuilder().addAllFieldErrors(fieldErrors).build()
                )
            }
        }

        fun validateListIdentityTypesRequest(req: ListIdentityTypesRequest): String? {
            val fieldErrors = mutableListOf<FieldError>()

            val tokenList = validateB64PageToken(req.pageToken, 1,
                { null }, "page_token", fieldErrors
            )

            fieldErrors.addAll(validateListPageSize(req.pageSize))

            if (fieldErrors.isNotEmpty()) {
                throw ValidationException(
                    Code.INVALID_ARGUMENT.name,
                    ErrorDetails.newBuilder().addAllFieldErrors(fieldErrors).build()
                )
            }

            return if (tokenList != null) {
                tokenList[0]
            } else {
                null
            }
        }

    }
}
