package ru.yandex.intranet.imscore.metrics;

import org.springframework.stereotype.Component;

import ru.yandex.monlib.metrics.primitives.GaugeInt64;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * Readiness metrics.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@Component
public class ProbeMetrics {

    private static final String POSTGRES_PING_ERROR = "readiness.postgres.ping.error";
    private static final String LIVENESS_OK_RATE = "liveness.ok.rate";
    private final GaugeInt64 postgresPingErrors;
    private final Rate livenessOkCount;

    public ProbeMetrics() {
        this.postgresPingErrors = MetricRegistry.root().gaugeInt64(POSTGRES_PING_ERROR);
        this.livenessOkCount = MetricRegistry.root().rate(LIVENESS_OK_RATE);
    }

    public void onLivenessProbe() {
        livenessOkCount.inc();
    }

    public void onReadinessProbe(boolean isPostgresError) {
        postgresPingErrors.set(isPostgresError ? 1L : 0L);
    }

}
