package ru.yandex.intranet.imscore.schedulers.local;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

/**
 * Local schedulers configuration.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@Configuration
@EnableScheduling
public class LocalSchedulersConfiguration implements SchedulingConfigurer {

    private final ThreadPoolTaskScheduler scheduler;

    public LocalSchedulersConfiguration(@Qualifier("localThreadPoolTaskScheduler") ThreadPoolTaskScheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void configureTasks(@NonNull ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.setTaskScheduler(scheduler);
    }

}
