package ru.yandex.intranet.imscore.util;

import java.util.concurrent.TimeUnit;

import static java.util.concurrent.TimeUnit.NANOSECONDS;

/**
 * One shot stopwatch, safe to share between threads.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public class OneShotStopWatch {

    private final long startTick;

    public OneShotStopWatch() {
        this.startTick = System.nanoTime();
    }

    public long elapsed(TimeUnit desiredUnit) {
        return desiredUnit.convert(System.nanoTime() - startTick, NANOSECONDS);
    }

}
