SET(net.byte-buddy.version 1.12.8)
SET(kotlin.version 1.6.10)
SET(kotlin-coroutines-core.version 1.6.1)
SET(kotlin-coroutines-core-jvm.version 1.6.1)
SET(spring-boot.version 2.6.6)
SET(spring-boot-starter-security.version 2.6.6)
SET(spring-boot-starter-data-jpa.version 2.6.6)
SET(spring-boot-configuration-processor.version 2.6.6)
SET(spring-boot-grpc.version 2.13.0.RELEASE)
SET(postgresql.version 42.3.1)
SET(liquibase.version 4.9.1)
SET(grpc.version 1.43.2)
SET(proto-google-common-protos.version 2.0.1)
SET(error-prone-annotations.version 2.9.0)
SET(guava.version 31.0.1-jre)
SET(checker-qual.version 3.12.0)
SET(hibernate-types.version 2.10.3)
SET(infinispan-hibernate-cache-v53.version 12.1.7.Final)
SET(disruptor.version 3.4.4)
SET(log4j2.version 2.17.2)

INCLUDE(${ARCADIA_ROOT}/contrib/java/org/springframework/boot/spring-boot-dependencies/${spring-boot.version}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/org/apache/logging/log4j/log4j-bom/${log4j2.version}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/org/jetbrains/kotlin/kotlin-bom/${kotlin.version}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/com/google/protobuf/protobuf-bom/${JAVA_PROTO_RUNTIME_VERSION}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/io/grpc/grpc-bom/${grpc.version}/ya.dependency_management.inc)

EXCLUDE(
    contrib/java/log4j/log4j
    contrib/java/commons-logging/commons-logging
    contrib/java/org/springframework/boot/spring-boot-starter-logging
    contrib/java/javax/activation/javax.activation-api
    contrib/java/javax/annotation/javax.annotation-api
    contrib/java/javax/persistence/javax.persistence-api
    contrib/java/org/apache/tomcat/tomcat-annotations-api
    contrib/java/org/jboss/spec/javax/transaction
    contrib/java/javax/xml/bind/jaxb-api
    contrib/java/com/google/protobuf/protobuf-javalite
    contrib/java/com/google/errorprone/error_prone_annotations
    contrib/java/org/checkerframework/checker-qual
)

DEPENDENCY_MANAGEMENT(
    contrib/java/net/bytebuddy/byte-buddy/${net.byte-buddy.version}
    contrib/java/org/jetbrains/kotlin/kotlin-reflect/${kotlin.version}
    contrib/java/org/jetbrains/kotlin/kotlin-stdlib/${kotlin.version}
    contrib/java/org/jetbrains/kotlinx/kotlinx-coroutines-core/${kotlin-coroutines-core.version}
    contrib/java/org/jetbrains/kotlinx/kotlinx-coroutines-core-jvm/${kotlin-coroutines-core-jvm.version}
    contrib/java/org/springframework/boot/spring-boot-starter-security/${spring-boot-starter-security.version}
    contrib/java/org/springframework/boot/spring-boot-starter-data-jpa/${spring-boot-starter-data-jpa.version}
    contrib/java/org/springframework/boot/spring-boot-configuration-processor/${spring-boot-configuration-processor.version}
    contrib/java/org/postgresql/postgresql/${postgresql.version}
    contrib/java/org/liquibase/liquibase-core/${liquibase.version}
    contrib/java/net/devh/grpc-spring-boot-starter/${spring-boot-grpc.version}
    contrib/java/com/google/api/grpc/proto-google-common-protos/${proto-google-common-protos.version}
    contrib/java/com/google/errorprone/error_prone_annotations/${error-prone-annotations.version}
    contrib/java/com/google/guava/guava/${guava.version}
    contrib/java/org/checkerframework/checker-qual/${checker-qual.version}
    contrib/java/com/vladmihalcea/hibernate-types-52/${hibernate-types.version}
    contrib/java/org/infinispan/infinispan-hibernate-cache-v53/${infinispan-hibernate-cache-v53.version}
    contrib/java/com/lmax/disruptor/${disruptor.version}
)
