import logging

from intranet.ims.staff_connector.staff_connector import settings
from intranet.ims.staff_connector.staff_connector.models import PingMessage

QUEUE = settings.PING_QUEUE

log = logging.getLogger(__name__)


async def produce_messages(queue):
    message = PingMessage(message='Hello, world!')
    await queue.send_message(MessageBody=message.json())
    log.info('Ping with id %s', message.id)


async def process_message(message):
    message = PingMessage.parse_raw(await message.body)
    log.info('Receive %s with id %s', message.message, message.id)
