import logging

from intranet.ims.staff_connector.staff_connector import settings
from intranet.ims.staff_connector.staff_connector.ims_client import IMSClient
from intranet.ims.staff_connector.staff_connector.models import User
from intranet.ims.staff_connector.staff_connector.staff_api_client import StaffAPIClient

QUEUE = settings.USER_QUEUE

log = logging.getLogger(__name__)


async def produce_messages(queue):
    staff_api = StaffAPIClient()
    users = await staff_api.get_users()
    for user_data in users:
        user = User.from_staff_api(**user_data)
        await queue.send_message(MessageBody=user.json())
        log.info('Push user with id %s', user.source_id)


async def process_message(message):
    user = User.parse_raw(await message.body)
    log.info('Receive %s with id %s', user.source_id)
    ims_client = IMSClient()
    await ims_client.push_user(user.dict())
