from typing import Dict, Any

import yarl

from intranet.ims.staff_connector.staff_connector import settings
from intranet.ims.staff_connector.staff_connector.utils.tvm import TVMAuthorizationMixin


class IMSClient(TVMAuthorizationMixin):
    PERSONS_URL = '/v3/persons'

    def __init__(self):
        if settings.IMS_API_URL is None:
            RuntimeError('IMS API url not configured')
        self._base_url = yarl.URL(settings.IMS_API_URL)

        if settings.IMS_TVM_ID is None:
            raise RuntimeError('IMS API TVM ID not configured')
        self._tvm_id = settings.IMS_TVM_ID

    async def push_user(self, params: Dict[str, Any]):
        pass
