import uuid

from pydantic import BaseModel, Field


class PingMessage(BaseModel):
    message: str
    id: str = Field(default_factory=lambda: str(uuid.uuid4()))


class User(BaseModel):
    source_id: str

    @classmethod
    def from_staff_api(cls, **kwargs) -> 'User':
        return User(**kwargs)
