import logging.config
import os
import importlib
import sys


YENV_TYPE = os.getenv('YENV_TYPE', 'development')

# Для автодополнения
from .default import Settings  # noqa: F402
settings = Settings()

config_module = importlib.import_module(f'{__package__}.{YENV_TYPE}')
settings = config_module.Settings()  # noqa

# Logging
LOG_FORMAT = 'json' if settings.ENV_TYPE != 'development' else 'default'
ENV_LOG_LEVEL = 'DEBUG' if settings.DEBUG or settings.ENV_TYPE == 'development' else 'INFO'

LOGGING_CONFIG = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'default': {
            '()': 'ylog.context.ContextFormatter',
            'datefmt': '%Y-%m-%d %H:%M:%S',
            'format': '[%(asctime)s][%(name)s] - %(levelname)s - %(message)s',
        },
        'json': {
            '()': 'ylog.format.QloudJsonFormatter',
        },
    },
    'handlers': {
        'stream': {
            'class': 'logging.StreamHandler',
            'formatter': LOG_FORMAT,
            'stream': sys.stdout,
            'level': ENV_LOG_LEVEL,
        },
    },
    'loggers': {
        'tvm2.aio.base': {
            'handlers': ['stream'],
            'level': ENV_LOG_LEVEL,
            'propagate': False,
        },
        'botocore.auth': {
            'handlers': ['stream'],
            'level': 'INFO',
            'propagate': False,
        },
        'botocore': {
            'handlers': ['stream'],
            'level': 'INFO',
            'propagate': False,
        },
        'asyncio': {
            'handlers': ['stream'],
            'level': 'INFO',
            'propagate': False,
        },
        'staff_connector': {
            'handlers': ['stream'],
            'propagate': False,
            'level': ENV_LOG_LEVEL,
        },
        'ya.test': {'level': 'WARNING'},
    },
    'root': {
        'handlers': ['stream'],
        'level': ENV_LOG_LEVEL,
    },
}

logging.config.dictConfig(LOGGING_CONFIG)
