from typing import Dict

import yenv
from pydantic import BaseSettings, BaseModel


class QueueAttributes(BaseModel):
    VisibilityTimeout: str = '60'


class Settings(BaseSettings):
    ENV_TYPE = yenv.type
    DEBUG: str = False

    # SQS
    SQS_HOST: str = 'sqs.yandex.net'
    SQS_PORT: str = '8771'
    SQS_SCHEME: str = 'http'

    @property
    def SQS_URL(self):
        return f'{self.SQS_SCHEME}://{self.SQS_HOST}:{self.SQS_PORT}'

    SQS_REGION_NAME: str = 'yandex'
    SQS_ACCESS_KEY_ID: str = 'ims'
    SQS_SECRET_ACCESS_KEY: str = 'unused'
    SQS_SESSION_TOKEN: str = None
    SQS_RECEIVE_MESSAGE_WAIT_TIMEOUT: int = 10

    # Queues
    PING_QUEUE: str = 'ims-ping-queue'
    USER_QUEUE: str = 'ims-staff-users-queue'
    QUEUES_ATTRIBUTES: Dict[str, QueueAttributes] = {
        PING_QUEUE: QueueAttributes(),
        USER_QUEUE: QueueAttributes(),
    }

    # API
    STAFF_API_URL: str = 'https://staff-api.yandex-team.ru'
    STAFF_API_TVM_ID: str = None
    IMS_API_URL: str = 'https://ims.yandex-team.ru'
    IMS_TVM_ID: str = None

    # TVM Auth
    TVM_CLIENT_ID: str = None
    TVM_CLIENT_SECRET: str = None
    BLACKBOX_API: str = 'https://blackbox.yandex-team.ru/blackbox'
