import aioboto3
import botocore.errorfactory

from intranet.ims.staff_connector.staff_connector import settings

_session = aioboto3.Session()


def get_sqs_context():
    return _session.resource(
        'sqs',
        endpoint_url=settings.SQS_URL,
        region_name=settings.SQS_REGION_NAME,
        aws_access_key_id=settings.SQS_ACCESS_KEY_ID,
        aws_secret_access_key=settings.SQS_SECRET_ACCESS_KEY,
        aws_session_token=settings.SQS_SESSION_TOKEN,
        use_ssl=False)


async def get_or_create_queue(name: str, *, sqs_client, **attributes, ):
    try:
        queue = await sqs_client.get_queue_by_name(QueueName=name)
        await queue.set_attributes(Attributes=attributes)
    except botocore.errorfactory.ClientError:
        queue = await sqs_client.create_queue(QueueName=name, Attributes=attributes,)
    return queue


async def consume_messages(queue, process_message):
    for message in (await queue.receive_messages(WaitTimeSeconds=settings.SQS_RECEIVE_MESSAGE_WAIT_TIMEOUT)):
        await process_message(message)
        await message.delete()
