from typing import Dict, Any

import yarl
from aiohttp import ClientSession

from intranet.ims.staff_connector.staff_connector import settings
from intranet.ims.staff_connector.staff_connector.utils.tvm import TVMAuthorizationMixin


class StaffAPIClient(TVMAuthorizationMixin):
    PERSONS_URL = '/v3/persons'

    def __init__(self):
        if settings.STAFF_API_URL is None:
            RuntimeError('Staff API url not configured')
        self._base_url = yarl.URL(settings.STAFF_API_URL)

        if settings.STAFF_API_TVM_ID is None:
            raise RuntimeError('Staff API TVM ID not configured')
        self._tvm_id = settings.STAFF_API_TVM_ID

    async def get_users(self, **params: Dict[str, Any]):
        async with ClientSession() as session:
            response = await session.get(
                self._base_url / self.PERSONS_URL,
                params=params,
                headers=await self.get_tvm_headers(),
            )
            response.raise_for_status()
            return await response.json()
