# coding: utf-8
from typing import Dict

from tvm2 import TVM2
from tvm2.exceptions import TVM2BaseException

from intranet.ims.staff_connector.staff_connector import settings


class TVMAuthorizationMixin:
    _tvm_id: str

    async def get_tvm_headers(self) -> Dict[str, str]:
        return {
            'X-Ya-Service-Ticket': await get_tvm_ticket(self._tvm_id),
        }


class NotAllTicketsException(TVM2BaseException):
    pass


def get_tvm_client() -> TVM2:
    return TVM2(
        client_id=settings.TVM_CLIENT_ID,
        secret=settings.TVM_CLIENT_SECRET,
        blackbox_client=settings.BLACKBOX_API,
        destinations=(),
        allowed_clients='*',
    )


async def get_tvm_ticket(destination: str) -> str:
    tvm_client = get_tvm_client()
    if destination not in tvm_client.destinations:
        tvm_client.add_destinations(destination)
    tickets = await tvm_client.get_service_tickets(destination)
    if destination in tickets and tickets[destination]:
        return tickets[destination]
    else:
        raise NotAllTicketsException()
